<?php

require_once('classes/DB.class.php');

class BCryptAuth{

    var $logPath = 'var/log/auth.txt';
    var $hashCost = 12;
    var $domain = '';
    var $ip = null;

    function __construct($domain){
        require_once('classes/phpHelpers.php');
        $this->domain = $domain;
        $this->ip = getUserIp();
        return;
    }

    function log($message){
        $logPath = $this->logPath;
    
        file_put_contents($logPath,date('m/d/Y H:i:s').' '.$message."\r\n \r\n ".$this->ip."\r\n \r\n ############################# END ######################### \r\n \r\n",FILE_APPEND);
        return;
    }

    function register($email,$password,$args = array()){

    $firstname = '';
    $lastname = '';
    $phone = '';
    $organization = '';
	$registerDate = '';
    $source = 'default';

    foreach($args as $arg => $value){
        switch($arg){
            case 'firstname':
                if(empty($value)){
                    throw new Exception('Firstname cannot be empty');
                }
                $firstname = DB::prepareVariable($value);
            break;
            case 'lastname':
                if(empty($value)){
                    throw new Exception('Lastname cannot be empty');
                }
                $lastname = DB::prepareVariable($value);
             break;
             case 'phone':
                $phone = DB::prepareVariable($value);
             break;
             case 'organization':
                $organization = DB::prepareVariable($value);
             break;
			 case 'date_registered':
				$registerDate = date('Y/m/d');
			break;
             case 'source':
                 $source = DB::prepareVariable($value);
             break;
        }
    }

        if(empty($email)){
            throw new Exception('Email cannot be empty');
        } 
        $email = DB::prepareVariable($email);

        $check = DB::run("SELECT COUNT(contactid) AS total FROM contacts WHERE email = '".$email."'")->fetch();

        if($check['total'] !== 0){
            throw new Exception('Email is already registered');
            return false;
        }

        $check = DB::run("SELECT COUNT(id) AS total FROM verify WHERE username = '".$email."'")->fetch();

        if($check['total'] !== 0){
            throw new Exception('Email is already registered');
            return false;
        }

        $quContact = "INSERT INTO contacts SET
        firstname = '$firstname',
        lastname = '$lastname',
        email = '$email',
        organization = '$organization',
        phone = '$phone',
		date_registered = '".$registerDate."',
        source = '$source'";

        $contactid = DB::run($quContact);

        if($contactid !== false){
            $quVerify = "INSERT INTO verify SET contactid='$contactid',
            username = '".$email."',
            password = '".DB::prepareVariable($this->generateHash($password))."'";
            
            if(DB::run($quVerify) !== false){
                return true;
            }
        }

        return false;

    }
	
	    function resetpass($contactid,$password,$args = array()){

        if(empty($contactid)){
            throw new Exception('contactid cannot be empty');
        } 
        $contactid = DB::prepareVariable($contactid);

            $quVerify = "UPDATE verify SET password = '".DB::prepareVariable($this->generateHash($password))."' WHERE contactid='$contactid'";
            
            if(DB::run($quVerify) !== false){
                return true;
            }
        

        return false;

    }

    function authorize($username,$password){

        $verification = $this->verify_credentials($username,$password);	
        $result = false;
        if($verification !== false){                
            return $this->session_start($verification); //TOKEN OR FALSE
        }
  
        return $result;

    }

/**
 *  @brief session_start
 *  
 *  @param [in]  $username 
 *  @param [in]  $password 
 *  @return bool
 *  
 *  @details START A NEW SESSION
 */
protected function session_start($verification){
    require_once('classes/phpHelpers.php');

    $ip = getUserIP();

    //GENERATE A NEW SESSION CODE
	$session_code = $this->session_code();
	
	$contactid = $verification['contactid'];
	$verifyid = $verification['id'];
	
	$query = "INSERT INTO sessions
	VALUES('','$session_code','$verifyid','$contactid','$ip',NOW(),'')";
	
	if(DB::run($query) !== false){
        
     //EXPIRE 12 HOURS   
    setcookie("SESS__", $session_code,   time() + (12 * 60 * 60), "/" , $this->domain); 

    DB::run("UPDATE verify SET last_login = NOW(), last_ip = '".$ip."' WHERE id = '".$verifyid."'");
        
    return $session_code;
		
	}else{
		return false;
	}
	
}

/**
 *  @brief sage_session_end
 *  
 *  @return bool
 *  
 *  @details END SESSION
 */
function session_end(){

	if(isset($_COOKIE['SESS__'])){
		$sessioncode = $_COOKIE['SESS__'];
		
		//LOGOUT ALL OTHER USERNAME SESSIONS
        $session = DB::run("SELECT COUNT(id) AS total,verify FROM sessions WHERE sessioncode = '".$sessioncode."'")->fetch();
		if($session['total'] !== 0){
			$verifyid = $session['verify'];
			DB::run("DELETE FROM sessions WHERE verify = '$verifyid'");
		}
		
		DB::run("DELETE FROM sessions WHERE sessioncode = '$sessioncode'");
		
		if(headers_sent() == false){
			setcookie("SESS__", '',   time() + (365 * 24 * 60 * 60), "/" , $this->domain); //EXPIRE 1 YEAR
				$past = time() - 3600;
				foreach ( $_COOKIE as $key => $value )
				{
						setcookie( $key, $value, $past, '/', $this->domain );
				}
		}
		
		unset($_COOKIE['SESS__']);
		foreach ( $_COOKIE as $key => $value )
		{
			unset($_COOKIE[$key]);
		}
		return true;	
	}
return true;
}

/**
 * returns the current logged in contactid
 */
function user(){
    return $this->check();
}

function check(){
    if(isset($_COOKIE['SESS__'])){
		$sessioncode = $_COOKIE['SESS__'];
		$session = DB::run("SELECT COUNT(contactid),contactid FROM sessions WHERE sessioncode = '".$sessioncode."'")->fetch();
		if($session["COUNT(contactid)"] == 0){
			$this->session_end();
			if(!headers_sent()){
				header("HTTP/1.1 403 Forbidden");
            }
            return false;
        }else{
            return $session['contactid'];
        }
    }
        return false;
}


  /**
     *  @brief verifypass
     *  
     *  @param string  $password
     *  @param string  $hashedPassword
     *  @return bool
     *  
     *  @details SEE IF A HASH MATCHES A HASHED PASSWORD
     */
    private function verifypass($password, $hashedPassword) {
        if (password_verify($password, $hashedPassword)) {
            return true;
        } else {
            return false;
        }
    }


        /**
     *  @brief verify_credentials
     *  
     *  @param [in]  $username USERNAME TO VERIFY
     *  @param [in]  $password PASSWORD TO VERIFY
     *  @return 
     *  
     *  @details VERIFY A PASSWORD IS VALID FOR A USER
     */
    private function verify_credentials($username,$password){
        
    //SANITIZE    
    $username = DB::prepareVariable($username);
    $password = DB::prepareVariable($password);

    //CHECK FOR BLANK SUBMISSION!
    if($username == ''){
        $this->log("Invalid Login to account ".$username." -BLANK USERNAME-");
        return false;
    }
    //CHECK FOR BLANK SUBMISSION!
    if($password == ''){
        $this->log("Invalid Login to account ".$username." -BLANK PASSWORD-");
        return false;
    }

    ///VERIFY THE USERNAME FIRST
    $verifyusername = DB::run("SELECT COUNT(username),contactid,password,id FROM verify WHERE username = '".$username."'")->fetch();
    if($verifyusername["COUNT(username)"] == 0){
        $this->log("Invalid Login to account ".$username." -invalid username-");
        return false; 
    }

    //NOW VERIFY PASSWORD
    if($this->verifypass($password,$verifyusername['password']) == false){
        $this->log("Invalid Login to account ".$username." -invalid password-");
        return false; 
    }else{
        return array('id' => $verifyusername['id'],'contactid' => $verifyusername['contactid']);
    }

    //RETURN FALSE IF ANYTHING AS DEFAULT
    return false; 
    }

    
/**
 *  @brief session_code
 *  
 *  @return SESSIONCODE
 *  
 *  @details GENERATE A SESSION CODE
 */
private function session_code($session_code = 'default'){

    if($session_code == 'default'){
        $session_code = $this->randomKey();
        
        //REGENERATE SESSION CODE IF IT ALREADY EXISTS
        while(DB::run("SELECT COUNT(id) AS total FROM sessions WHERE sessioncode = '".$session_code."'")->fetch()['total'] !== 0){
            $session_code = $this->randomKey();
        }
        
    }else{
        $qu = DB::run("SELECT COUNT(id) AS total FROM sessions WHERE sessioncode = '".$session_code."'")->fetch();
        if($qu['total'] == 0){
            return $session_code;
        }else{
            return false;
        }
    }
	return $session_code;
}

/**
 *  @brief randomKey
 *  
 *  @return string RANDOM GENERATED KEY
 *  
 *  @details used to generate a random hash
 */
function randomKey() {
    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
    $pass = array(); //remember to declare $pass as an array
    $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    for ($i = 0; $i < 50; $i++) {
        $n = rand(0, $alphaLength);
        $pass[] = $alphabet[$n];
    }
    return implode($pass); //turn the array into a string
}



    /**
     *  @brief generateHash
     *  
     *  @param string  $password
     *  @return HASHED_PASSWORD
     *  
     *  @details USED TO CREATE A BCRYPT PASSWORD
     */
    function generateHash($password) {
            
            /*
            md5($password)
                180 BILLION guesses per second
                9.4 Hours - All possible 8 character passwords
            sha1($password)
                61 BILLION guesses per second
                27 Hours - All possible 8 character passwords
            md5crypt (which is very similar to phpass with a cost of 10):
                77 Million guesses per second
                2.5 Years - All possible 8 character passwords
            bcrypt with a cost of 5
                71 Thousand guesses per second
                2700 Years - All possible 8 character passwords
            */
            
            if (defined("CRYPT_BLOWFISH") && CRYPT_BLOWFISH) {
                $options = array('cost' => $this->hashCost);
                $hash = password_hash($password, PASSWORD_BCRYPT, $options);
                while(strpos($hash,'/') !== false){
                        $hash = password_hash($password, PASSWORD_BCRYPT, $options);
                }
                return $hash;
            }else {
                echo "CRYPT_BLOWFISH is not available";
                return false;
                }
        }

}

?>