//SIMPLE CLASS TO DYNAMICALLY LAZY LOAD DASHBOARD CONTENT
window.onload = function(){

    m = new minuteman();
    m.processAll();

};

window.onscroll = function(){

    m = new minuteman();
    m.processAll();

}

//USE BY LOADING THIS CLASS AND ADDING ELEMENTS WITH ATTRIBUTES
// data-minuteman-path='{AJAX PATH}' data-minuteman='{TRUE OR onload}' 
var minutemanElemsCache = null;
class minuteman{

    constructor(path,method='GET'){
        this.path = path;
        this.method = method;
    }

    //el = ELEMENT IN PAGE
    inView(el) {
        var rect = el.getBoundingClientRect();
        return rect.bottom < 0 || rect.right < 0 || rect.left > window.innerWidth || rect.top > window.innerHeight;
    }

    //GET ALL ELEMENTS WITH MINUTEMAN ATTRIBUTE
    getAll(){
        if(minutemanElemsCache == null){
            minutemanElemsCache = document.querySelectorAll('[data-minuteman]');
        }
        return minutemanElemsCache;
    }

    getData(path,element){
        console.log('MINUTEMAN: getting data from '+ path)
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
                console.log( 'MINUTEMAN LOADED '+element.id );
                element.outerHTML = this.responseText;
                element.setAttribute('data-minuteman','loaded');
            }
        };
        xhttp.open(this.method, path, true);
        xhttp.send();
    }

    processAll(){
        var elems = this.getAll();
        for(var i = 0, n = elems.length; i < n; i++){
            //console.log(this.inView(elems[i]));
            if(elems[i].getAttribute('data-minuteman') == 'onload' || this.inView(elems[i])){
                if(elems[i].getAttribute('data-minuteman') !== 'loaded'){
                    elems[i].innerHTML = 'Loading...';
                    elems[i].setAttribute('data-minuteman','loaded');
                    var ht = this.getData(elems[i].getAttribute('data-minuteman-path'),elems[i]);
                }
            }
        }

        return true;
    }

}
