<?php
if(file_exists('config/coreconfig.php')){
	require_once('config/coreconfig.php');
	
	if($config['debug'] == false){
		error_reporting(E_ALL ^ E_WARNING ^ E_NOTICE ^ E_DEPRECATED ^ E_USER_DEPRECATED ); 
	}else{
		error_reporting(E_ALL);
	}
}

require_once('classes/phpHelpers.php');

//DONT INCLUDE SCRIPTS IF PART OF API POST
if(!isset($_POST) or empty($_POST)){ ?>
<!DOCTYPE html>
<head>

<?php 
if(file_exists('application/head.php')){
	include_once('application/head.php');
}
?>

<!-- JQUERY MIN  https://jquery.com/ -->
<script src="default/libs/jquery/jquery-3.3.1.min.js"></script>
<!--<script src="default/libs/jquery/jquery-3.2.1.slim.min.js"></script>-->

<!-- POPPER FOR TOOLTIPS -->
<script src="default/libs/popper/popper.min.js"  ></script>

<!-- BOOTSTRAP 4 FOR BASIC STYLING https://getbootstrap.com/docs/4.0/getting-started/introduction/ -->
<link rel="stylesheet" href="default/libs/bootstrap4/css/bootstrap.min.css">
<script src="default/libs/bootstrap4/js/bootstrap.min.js" ></script>

<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- STYLES LOCATED IN THEME FOLDER -->
<link rel="stylesheet" href="theme/css/styles.css" type="text/css" />
<link rel="stylesheet" href="theme/css/mobile.css" type="text/css" media="only screen and (max-device-width: 480px)"  />

<!-- STYLES LOCATED IN THEME DEFAULT FOLDER -->
<link rel="stylesheet" href="default/theme/styles.css" type="text/css" />
<link rel="stylesheet" href="default/theme/mobile.css" type="text/css" media="only screen and (max-device-width: 480px)"  />

<!-- MINUTEMAN DYNAMICALLY LOADS DASHBOARD CONTENT -->
<script src="classes/minuteman.class.js"></script>

<script src='classes/javascriptHelpers.js' ></script>

<!-- JQSEND MAKES IT EASY TO USE AJAX FORMS -->
<script src='classes/jQsend/jQsend.js' ></script>
<link rel="stylesheet" href="classes/jQsend/jQsend.css" type="text/css" />

</head>
<body>


<?php 
if(getUserIP() == '127.0.0.1'){
if(isset($_GET['_adaptive'])){ ?>
<script src="classes/adaptive.js"></script>
<div id="devconsole" ><b>ADAPTIVE MODE IS ON!</b><br /><a href="?normal" >Exit Adaptive Mode</a><ul id="devoutput" ></ul></div>
<script>
$(document).ready(function(){
 $('form').append("<input type='hidden' name='_adaptive' value='1' />");
 $('body').addClass('adaptiveBody');
});
</script>
<?php }else{ ?>

<script>
$(document).ready(function(){
$('body').prepend('<div id="devmode" ><a href="?_adaptive" >Welcome developer - Click here to enter adaptive mode</a></div>');
});
</script>

<?php }} ?>

<?php

} //END FIRST CHECK FOR POST


//CHECK FOR NEED TO INSTALL
if(!file_exists('config/coreconfig.php')){
	
	require('install.php');
	exit();
}

require_once("classes/DB.class.php");
require_once("main.class.php");

//GET APPLICATION SPECIFIC CLASS
if(file_exists("application/application.class.php")){
	require_once("application/application.class.php");
}

$application = new main();

require_once('classes/speedDemon.class.php');
require_once('classes/logger.class.php');
$log = new logger('errors.log','log');

$speedDemon = new speedDemon(5.00,__DIR__.'/var/log/speedDemon.txt');
//$speedDemon->speedTest(30000);

$currentUri = parseURI();

//print_r($currentUri);

//LIST OF ACCEPTABLE NO-AUTH NEEDED PAGES
$noAuths = array('login','update','install','commit','signup','cron','reset');

//GO TO LOGIN IF NOT LOGGED IN
if(!in_array($currentUri['page'],$noAuths)){
    if(!$application->loggedIn()){
      $currentUri = array('page' => 'login','redirect' => $currentUri['page']);
    }
}

//TESTING ONLY
//print_r($currentUri);

$defaultfile = "default/".$currentUri['page'].".php";
$file = "src/".$currentUri['page'].".php";

//CHECK FOR DASH ELEMENTS
if($currentUri['page'] == 'dash' AND isset($_GET['element'])){
    $file = "src/dash/".$_GET['element'].".php";
}

if($currentUri['page'] == 'cron'){
	$application->cronTasks();
	exit();
}

if($currentUri['page'] == 'commit'){
	require_once('classes/UpdStruct.class.php');
	$exporter = new UpdStruct();
	$exporter->connect($config['database_name'],$config['database_user'],$config['database_pass'],$config['database_host']);
	$exporter->project = $config['project'];
	$exporter->showTables();
	if(!file_exists('VERSION.txt')){
		$version = 0.01;
	}else{
		$version = file_get_contents('VERSION.txt');
	}
	
	if($config['project'] !== 'default'){
	$exporter->database_version = floatval($version) + 0.01; //commit to next version
	}else{
	$exporter->database_version = 0.01; //commit to next version
	}
	
	$exporter->export();
	exit();
	
}elseif($currentUri['page'] == 'update'){
	include('updater.php');
	exit();

}elseif(file_exists($file)){
    //IF SO REQUIRE IT
    require($file);
}elseif(file_exists($defaultfile)){ ///IF NO FILE IN SRC - LOOK IN /DEFAULT
    //IF SO REQUIRE IT
    require($defaultfile);
}elseif(isset($_POST) and !empty($_POST)){ //SECOND POST CHECK
    http_response_code(400);
    $err = json_encode(array('result' => "We've received the following data without any purpose",'data' => $_POST));
    $log->log($err);
    echo $err;
    exit(); 
}else{
    $application->checkAuth();
}



//REDIRECT TO HOME IF LOGGED IN AND YOU VISIT /LOGIN
if($application->loggedIn() !== false and strtolower($currentUri['page']) == 'login'){ 
        $currentUri['page'] = 'home';
}

//THIRD POST CHECK
if($currentUri['page'] !== 'dash' AND ( !isset($_POST) or empty($_POST))){

//LOADED LAST. PUT ANY POST LOAD SCRIPTS HERE
if(isset($currentUri['args']['message'])){
    $message = $currentUri['args']['message'];
    $title = isset($currentUri['args']['title']) ? $currentUri['args']['title'] : 'Message';
	$str = "<h1>".$title."</h1><p>".$message."</p>";
	
	echo "<script>$(document).ready(function(){ output('".$str."'); }); </script>";
	
}

    if(!isset($_NOFOOTER)){
        require('footer.php');
    }

?>
</body>
</html>
<?php } ?>