<?php

$version_next = file_get_contents($config['updatepath'].'/current.txt');
if(!file_exists('COREVERSION.txt')){
		$current_installed_version = 0.01;
}else{
	$current_installed_version = file_get_contents('COREVERSION.txt');
}
echo "Checking for updates... Currently Installed Version ".$current_installed_version.". Latest Version Available ".$version_next."<br />";

$updatePathLocal = pathinfo(realpath(__FILE__), PATHINFO_DIRNAME);

$updatethis = false;
$packagename = '';
if($current_installed_version < $version_next){
	echo "Running Update from ".$current_installed_version." to ".$version_next."<br />";
	$packagename = 'version_'.str_replace('.','',$version_next).'_core.zip';
	$updatethis = $config['updatepath'].'/'.$packagename;
}

if($updatethis !== false){

//CHECK FOR ALREADY DOWNLOADED UPDATE PACKAGE
if(!file_exists($updatePathLocal.'/'.$packagename)){
	
echo "Downloading update package from ".$updatethis." to ". $config['rootfiles']."<br />";

// copy the file from source server
$copy = copy($config['updatepath'], $updatePathLocal);

if(!$copy){
	echo("<br /><br />Couldnt copy file to ".$updatePathLocal." due to permissions.<br /> <a target='_blank'  href='".$updatethis."' >Download the update package</a><br /><ol><li>Download the update package.</li><li>Move the update package to your root install directory [ ".$updatePathLocal." ].</li><li><a href='".$config['root']."/update' >Click here to attempt to extract automatically.</a></li><li>If this fails, manually extract the contents of the zip file to [ ".$updatePathLocal." ].</li></ol><br /><br />"); 
	
}

}else{
	
	echo "Update package found in ".$updatePathLocal.'/'.$packagename." -- proceeding with update<br />";
	
	// unzip update
	$zip = new ZipArchive;
	$res = $zip->open($updatePathLocal.'/'.$packagename);
	if($res === TRUE){
		$zip->extractTo( $updatePathLocal );
		$zip->close();
		echo "Successfully applied update file <br />";
		echo "Running some housecleaning <br />";
	
		// delete zip file
		unlink($updatePathLocal.'/'.$packagename);
		
		echo "Housecleaning complete. <br />";
		
		// update users local core version number file
		$userfile = fopen ("COREVERSION.txt", "w");
		fwrite($userfile, $version_next);  
		fclose($userfile);
		
	}else{
		
		echo('error unzipping '.$updatePathLocal.'/'.$packagename.'<br />');
		
		// delete potentially corrupt file
		unlink($updatePathLocal.'/'.$packagename);
	}
}

}else{
		echo "<b>No core update required. You're all set!</b><br /><br />";
}

	
	echo "Checking for database updates<br />";

	require_once('classes/UpdStruct.class.php');
	$updater = new UpdStruct();
	$updater->connect($config['database_name'],$config['database_user'],$config['database_pass'],$config['database_host']);
	$updater->project = $config['project'];
	$updater->showTables();
	
	if(!file_exists('VERSION.txt')){
		$version = 0.01;
	}else{
		$version = file_get_contents('VERSION.txt');
	}

		
	if(!file_exists('structure/'.$config['project'].'_latest.txt')){
		if($version == 0.01){
			
			$nextdbversion = $version;
			
		}else{
		
			$nextdbversion = $version + 0.01;
		
		}
	}else{
		$nextdbversion = file_get_contents('structure/'.$config['project'].'_latest.txt');
	}
	
	if($version < $nextdbversion){
		echo "Upgrading database...This may take a minute.<br /><br />";
		echo "Upgrading from database version ".$version." to ".$nextdbversion."<br />";
		
		$updater->database_version = $nextdbversion;
		//$updater->export();
		if($updater->update() !== false){
		
			echo "<br /><br /><b>Database upgraded successfully.<br /><br />";
			$userfile = fopen ("VERSION.txt", "w");
			fwrite($userfile, $nextdbversion);  
			fclose($userfile);
		}else{
			echo "<br /><br /><b>Database upgrade FAILED - see logs.<br /><br />";
		}
	}else{
		echo "No database upgrade needed for this project.<br /><br />";
	}
	
		echo "<div style='display:none;' >Checking default structure<br />";
		
		$updater->project = 'default';
		$updater->showTables();
		$updater->database_version = 0.01;
		$updater->update();
		
		echo "</div>";


		echo "<br /><b>Update Complete!</b><br />";
?>