<?php 
require("classes/DB.class.php");
require('config/coreconfig.php');
require_once('classes/logger.class.php');
$log = new logger('errors.log','log');

require_once('classes/phpHelpers.php');
require_once('classes/speedDemon.class.php');

$speedDemon = new speedDemon(2.00,__DIR__.'/var/log/speedDemon_API_REQUESTS.txt');
//$speedDemon->speedTest(30000);

//APP CLASS
require_once('main.class.php');

//INIT MAIN APPLICATION CLASS
$application = new main();

$tmpHandler = parseURI();

//print_r($tmpHandler);
$handler = '';
//CANT ACCEPT REQUESTS WHERE THERE IS .PHP
if(strpos(strtolower($tmpHandler['page']),'.php') !== false){
        $log->log('INVALID REQUEST DUE TO .PHP IN API REQUEST');
        http_response_code(400);
        $err = json_encode(array('result' => "INVALID API ENDPOINT",'data' => $_POST));
        $log->log($err);
        echo $err;
    exit(); 
}

if(strtolower($tmpHandler['page']) == 'api'){

    if(isset($_POST['form-handler'])){
        $handler = $_POST['form-handler'];
    }
	
}else{
    $handler = $tmpHandler['page'];
}

//echo $handler;

if($handler == ''){
	$log->log('INVALID REQUEST DUE TO NO HANDLER IN API REQUEST');
	http_response_code(400);
	$err = json_encode(array('result' => "INVALID OR MISSING HANDLER",'data' => $_POST));
	$log->log($err);
	echo $err;
	exit(); 
}

//ONLY ALLOW ACCESS IF THEY ARE AUTHENTICATING
$allows = array('auth','register','resetpassword','reset');
if(!in_array($handler,$allows)){

    //CHECK #1 - DO YOU HAVE A SESSION COOKIE
    if($application->loggedIn() == false){
        http_response_code(401); //ACCESS DENIED
        echo json_encode(array('result' => 'ACCESS DENIED'));
        exit();
    }

    //CHECK #2 - DO YOU HAVE AN AUTHORIZATION KEY

    ////////todo +NATHAN/////////

}

//RUN ADAPTIVE MODE
if(isset($_POST['_adaptive'])){
	require_once('classes/adaptive.class.php');
	$adaptive = new adaptive($handler);
}

//+++++++++++  DONT DEFINE YOUR FUNCTIONS HERE IN CUSTOM API FILE! ++++++++++++++++++
if(file_exists('application/api.php')){
	include('application/api.php');
}
//+++++++++++  ONLY REFERENCE A FUNCTION FROM THE APLICATION CLASS TO KEEP IT NEAT!+++++++++++

if(!isset($_POST['_adaptive'])){
if(file_exists('application/functions/'.$handler.'.php')){
	include_once('application/functions/'.$handler.'.php');
	
	if(function_exists($handler)){
		call_user_func($handler);
	}else{
		exit($handler.'() doesnt exist!');
	}
}
}

switch($handler){
	case "register":
      $application->register();
        break;	
	case "resetpassword":
      $application->resetpassword();
        break;	
	case "reset":
      $application->resetfinal();
        break;	
    case "auth":
		$application->auth();
    break;
    case "generateKey":
		if(is_ajax_request()){
			echo json_encode(array('result' => randomKey()));
		}else{
			echo randomKey();
		}
    break;
    ///////END FRAMEWORK SPECIFIC DEFAULTS///////
}

exit();