<?php 

class main{

	var $path = '';

    function __construct(){
		
        return true;

    }
	
	//ADD REFERENCES TO ANY CRON FUNCTIONS
	function cronTasks(){
		if(file_exists($this->path.'application/cron.php')){
			require($this->path.'application/cron.php');
		}
	}
	
	//LOGIN
	function auth(){
		require($this->path.'config/coreconfig.php');
		require_once($this->path.'classes/BCryptAuth.class.php');
		$auth = new BCryptAuth($config['rootdomain']);

		$result = false;
		if(isset($_POST['email']) AND isset($_POST['password'])){

			$username = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_STRING);
			$password = filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING);

			$redirect = $config['root'].'/home';
			if(isset($_POST['redirect']) AND $_POST['redirect'] !== ''){
				//CHECK THAT ROOT DOMAIN IS ACTUALLY IN URL
				if(strpos($_POST['redirect'],$config['root']) !== false){
				
					$redirect = $_POST['redirect'];
								
			  }
			}

			$token = $auth->authorize($username,$password);
			$result = $token !== false ? $token : false;
			
			echo json_encode(array('result' => $result, 'redirect' => $redirect,'token' => $token));

		}else{
				echo json_encode(array('result' => $result, 'redirect' => $redirect,'token' => false));
				exit();
		}
	}
	
    function resetpassword(){

        require($this->path.'config/coreconfig.php');

$result = array('result' => false);
    
        $email = '';
        if(isset($_POST['email'])){
            $email = DB::prepareVariable($_POST['email']);
        }else{
            exit('NO email SET');
            $log->log('NO email SET'); 
        }
    
       
		$qu = DB::run("SELECT contactid FROM contacts WHERE email = '".$email."'")->fetch();
		
		if(isset($qu['contactid']) AND $qu['contactid'] !== 0){
		
			$body = "<p>Hello, </p>";
			$body .= "<p>We have received a password reset request for ".$config['project'].". If this is an error, no action is required. Otherwise click the link below to reset your password</p>";
			$noncegen = $this->storeNonce($qu['contactid'],'verify');
			$body .="<a href='".$config['root']."/reset?i=".$qu['contactid']."&token=".$noncegen."' >Reset my password</a>";


			//CREATE SUBJECT
			$subject = "Password Reset for InspecTime";

			//ADD EMAILS
			$emails = array($email => '');
			
			//exit($body);
			
			//SEND EMAIL
			$this->email($emails,$body,$subject);
			
			$result['result'] = true;
			$result['nonce'] = $config['root']."/reset?i=".$qu['contactid']."&token=".$noncegen;
			
			
		}
                
				
				
			echo json_encode($result);
			return;
	}
	
		function resetfinal(){

        require($this->path.'config/coreconfig.php');

   
        $contactid = '';
        if(isset($_POST['contactid'])){
            $contactid = DB::prepareVariable($_POST['contactid']);
        }else{
            exit('NO contactid SET');
            $log->log('NO contactid SET'); 
        }
    
      
		$password = '';
        if(isset($_POST['password']) AND isset($_POST['password2'])){
			$password = DB::prepareVariable($_POST['password']);
			$password2 = DB::prepareVariable($_POST['password2']);
			if($password !== $password2){
				go($config['root'].'/signup?message=Passwords do not match');
				throw new Exception('passwords do not match');
				return false;
			}
        }else{
			throw new Exception('no password set');
			return false;
		}
	
		require($this->path.'classes/BCryptAuth.class.php');
		   $auth = new BCryptAuth($config['rootdomain']);
		

        try{
			$result = $auth->resetpass($contactid,$password);
			$message = 'Your password is reset.';
        }catch(Exception $e){
			$message = $e->getMessage();
			exit($message);
        }

        
            go($config['root'] .'/login?message='.urlencode($message));
            exit();

                
	}
	
	   function register(){

        require($this->path.'config/coreconfig.php');

        $firstname = '';
        if(isset($_POST['firstname'])){
            $firstname = DB::prepareVariable($_POST['firstname']);
        }else{
            exit('NO FIRSTNAME SET');
            $log->log('NO FIRSTNAME SET'); 
        }
    
        $lastname = '';
        if(isset($_POST['lastname'])){
            $lastname = DB::prepareVariable($_POST['lastname']);
        }else{
            exit('NO LASTNAME SET');
            $log->log('NO LASTNAME SET'); 
        }
    
        $email = '';
        if(isset($_POST['email'])){
            $email = DB::prepareVariable($_POST['email']);
        }else{
            exit('NO email SET');
            $log->log('NO email SET'); 
        }
    
        $organization = '';
        if(isset($_POST['organization'])){
            $organization = DB::prepareVariable($_POST['organization']);
        }
    
        $phone = '';
        if(isset($_POST['phone'])){
            $phone = DB::prepareVariable($_POST['phone']);
		}
		
		$password = '';
        if(isset($_POST['password']) AND isset($_POST['password2'])){
			$password = DB::prepareVariable($_POST['password']);
			$password2 = DB::prepareVariable($_POST['password2']);
			if($password !== $password2){
				go($config['root'].'/signup?message=Passwords do not match');
				throw new Exception('passwords do not match');
				return false;
			}
        }else{
			throw new Exception('no password set');
			return false;
		}
	
		require($this->path.'classes/BCryptAuth.class.php');
		   $auth = new BCryptAuth($config['rootdomain']);
		   		   
			$registerDate = date('Y/m/d');
		   
		   $regArgs = array('firstname' => $firstname,'lastname' => $lastname,'phone' => $phone, 'organization' => $organization, 'date_registered' => $registerDate);
		   
		   $sqlquery = DB::run("UPDATE contacts SET date_registered = '".$registerDate."' WHERE email = '".$email."'");

        try{
			$register = $auth->register($email,$password,$regArgs);
			$message = 'Thank you '.$firstname.' for registering.';
        }catch(Exception $e){
			$message = $e->getMessage();
        }

       
            go($config['root'] .'/login?message='.urlencode($message));
            exit();
        
                
	}


	function loggedIn(){
		require_once($this->path.'classes/BCryptAuth.class.php');
		require($this->path.'config/coreconfig.php');
		$auth = new BCryptAuth($config['rootdomain']);
		return($auth->check());		
	}

	function contactid(){
		return $this->loggedIn();
	}


	function checkAuth(){
		require($this->path.'config/coreconfig.php');
		if($this->loggedIn()){
			go($config['root'] .'/home');
		}else{
			//OTHERWISE GO TO LOGIN
			http_response_code(404);
			go("login?message=Please+Login"); 
			//USES JAVASCRIPT REDIRECT SO BOTS DONT JUST INDEX THAT PAGE. ALONG WITH 404 HTTP RESPONSE
			exit();
		}
	}
	

	/*
	 * FUNCTION FOR SENDING EMAILS
	 * 	$emails = array('sagedread@gmail.com' => 'john doe','sagedread2@gmail.com' => 'john doe2');
	 * to use ics, simply pass the ics class object
	 */
	function email($emails,$body,$subject,$attachments = null,$ics = null){
		require_once($this->path.'classes/talariaMail.class.php');
		require($this->path.'config/coreconfig.php');
		
		$mailer = new talariaMail($emails,$subject,$body);
		//SET LOG PATH
		$mailer->logPath = 'var/log/mail_log.txt';
		//SET LOG MODE ACCEPTS all,errors,none
		$mailer->logMode = 'all';
		//SET FROM EMAIL AND FROM NAME
		$mailer->fromEmail = 'team@'.$config['rootdomain'];
		$mailer->fromName = $config['project'];

		//ADD ATTACHMENTS
		///$attachments = array('tmp/file.jpg' => array('name' => 'filename.jpg'));
		///////OR
		///$attachments = array('tmp/file.jpg','tmp/file2.jpg');
		if($attachments !== null AND is_array($attachments)){ $mailer->attachments = $attachments; }

		//ADD ICS INLINE
		if($ics !== null) {  $mailer->phpmailer_instance->addStringAttachment($ics->render(false),'invitation.ics'); }

		//OVERRIDE TEMPLATE TO INCLUDE LOGO AND SUCH
		$mailer->template = "<html><body style='padding:10px;color:#333;font-size:16px;' ><div style='max-width:600px;margin:0 auto;' >
		<div style='padding:10px;margin:5px auto;border-radius:5px;background:#f4f6f7;min-height:100px;'> 
		{BODY}
		</div></body></html>";

		//ACTUALLY SEND THE EMAIL
		if($mailer->send()){
			return true;
		}else{
			return false;
		}
	}
	
		/**
 *  @brief storeNonce
 *  
 *  @param [in]  $id IDENTIFIER USED TO VERIFY THE NONCE
 *  @param [in]  $type TYPE OF NONCE - USED TO VERIFY ID AGAINST TYPE
 *  @return [string] $nonce;
 *  
 *  @details NONCEs ( Numbers only used once ) are used to allow temporary access to specific data bypassing the checkSageSession() function.
 */
function storeNonce($id,$type){
	$returnable = false;
	while($returnable == false){
		$nonce = $this->generateHash($id."_".$type,5);
		//echo $nonce;
		$qu = 'SELECT COUNT(id) FROM nonce WHERE nonce = "'.$nonce.'"';
		//echo $qu;
		$existnonce = DB::run($qu)->fetch();
		//print_r( $existnonce);
		if($existnonce['COUNT(id)'] == 0){
			
		
			if(DB::run("INSERT INTO nonce SET
			nonce='$nonce',
			type='$type',
			date=NOW()") !== false){
					$returnable = true;
			//echo $returnable;
					return $nonce;
			}else{
				exit('SOMETHING WENT WRONG GENERATING NONCE');
			}
		}
	}
	

	return $nonce;
}

/**
 *  @brief verifyNonce
 *  
 *  @param [in]  $id IDENTIFIER USED TO CREATE THE NONCE
 *  @param [in]  $type TYPE USED TO CREATE THE NONCE
 *  @param [in]  $nonce THE NONCE BEING VERIFIED
 *  @return [bool] 
 *  
 *  @details Used to verify a nonce is valid
 */
function verifyNonce($id, $type, $nonce) {
	$existnonce = DB::run("SELECT COUNT(id) FROM nonce WHERE nonce = '".$nonce."'")->fetch();
	if($existnonce['COUNT(id)'] == 0){
		return false;
	}elseif (password_verify($id."_".$type, $nonce)) {
    return true;
} else {
    return false;
}
}

	/**
 *  @brief generateHash
 *  
 *  @param string  $password
 *  @return HASHED_PASSWORD
 *  
 *  @details USED TO CREATE A BCRYPT PASSWORD
 */
function generateHash($password,$cost = 12) {
	
	/*
    md5($password)
        180 BILLION guesses per second
        9.4 Hours - All possible 8 character passwords
    sha1($password)
        61 BILLION guesses per second
        27 Hours - All possible 8 character passwords
    md5crypt (which is very similar to phpass with a cost of 10):
        77 Million guesses per second
        2.5 Years - All possible 8 character passwords
    bcrypt with a cost of 5
        71 Thousand guesses per second
        2700 Years - All possible 8 character passwords
	*/
	
    if (defined("CRYPT_BLOWFISH") && CRYPT_BLOWFISH) {
	$options = array('cost' => $cost);
	$hash = password_hash($password, PASSWORD_BCRYPT, $options);
	while(strpos($hash,'/') !== false){
			$hash = password_hash($password, PASSWORD_BCRYPT, $options);
	}
	return $hash;
	}else {
		echo "CRYPT_BLOWFISH is not available";
		return false;
		}
	}

}


?>