<?php 
class DB
{

		//SET THIS UP IN CONFIG/CORECONFIG.PHP 
		protected static $DBconfig = array('database_host' => '','database_name' => '','database_user' => '','database_pass' => '','debug' => false);

    protected static $instance = null;

    private function __construct() {}
		private function __clone() {}

    public static function instance()
    {

			if(file_exists('coreconfig.php')){
				require('coreconfig.php');
			}elseif(file_exists('config/coreconfig.php')){
				require('config/coreconfig.php');
			}elseif(file_exists('../../config/coreconfig.php')){
				require('../../config/coreconfig.php');
			}else{ exit('cant load config'); }


			self::$DBconfig = array('database_host' => $config['database_host'],'database_name' => $config['database_name'],'database_user' => $config['database_user'],'database_pass' => $config['database_pass'],'debug' => $config['debug']);


			$DBconfig = self::$DBconfig;
			if($DBconfig['debug'] == false){
				$pdo_reporting_type = PDO::ERRMODE_WARNING;
			}else{
				$pdo_reporting_type = PDO::ERRMODE_EXCEPTION;
			}
        if (self::$instance === null)
        {
            $opt  = array(
                PDO::ATTR_ERRMODE            => $pdo_reporting_type,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => FALSE
            );
            $dsn = 'mysql:host='.$DBconfig['database_host'].';dbname='.$DBconfig['database_name'].';charset=utf8';
            self::$instance = new PDO($dsn, $DBconfig['database_user'], $DBconfig['database_pass'], $opt);
        }
        return self::$instance;
    }

    public static function __callStatic($method, $args)
    {
        return call_user_func_array(array(self::instance(), $method), $args);
    }

    public static function run($sql, $args = [])
    {
            //require('config/coreconfig.php');
            /*
			if($config['debug'] == true){ 
				//logError($sql);
				$bt = debug_backtrace();
				$caller = array_shift($bt);
				//logError(json_encode($bt) );
            }
            */
			//CHECK THAT ARGS IS AN ARRAY
			if(!is_array($args)){
				$args = array();
			}
			   
			try{

				if( $stmt = self::instance()->prepare($sql) ){
					
					$stmt->execute($args);

				}else{
					//print  $stmt->errno. " ". $stmt->error;
					//exit();
					self::log('Error preparing statement'. $stmt->errno. " ". $stmt->error." ".$sql);
					//exit();
				}
				
			}catch(PDOException $e){
				//echo $sql."    ".$e." SQL QUERY: ".$sql;
				//logError($sql."    ".$e." SQL QUERY: ".$sql);
				self::log("Error with SQL Query: \r\n \r\n  ".$sql." \r\n  \r\n PDOException ".$e->getMessage());
				exit();
			}catch(Exception $e){
				//echo $sql."    ".$e." SQL QUERY: ".$sql;
				//logError($sql."    ".$e." SQL QUERY: ".$sql);
				self::log("Error with SQL Query: \r\n \r\n  ".$sql." \r\n  \r\n PDOException ".$e->getMessage());
				exit();
			}

				if(strpos($sql,'INSERT') !== false AND $stmt !== false){
					return self::lastInsertId();
				}else{
					return $stmt;
				}
	}
	
	public static function prepareVariable($var){
		$var = str_ireplace(array("'",'"'),'&quot;',$var);
		$var = self::instance()->quote($var);
		$var = str_ireplace(array("'",'"',"`",","),'',$var);
		$var = filter_var($var,FILTER_SANITIZE_STRING);
		return $var;
	}
		
		public static function log($message){
					$logPath = 'var/log/database_error.txt';
			//echo $message."<br />";
			//echo $logPath;
					file_put_contents($logPath,date('m/d/Y H:i:s').' '.$message."\r\n   \r\n     BACKTRACE: \r\n \r\n ".print_r(debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS),true)."\r\n \r\n ############################# END ######################### \r\n \r\n",FILE_APPEND);
					return;
			}

		public static function getdata($page,$ref,$index){
			//print 'index='.$index;
			$sql = "SELECT * FROM ".$page." WHERE ".$ref."= :index";
			//logError( $sql." DONE - ".filtertofriendlytime(date('m-d-Y')));
			//$row = DB::run("SELECT * FROM pdowrapper WHERE id=?", [$id])->fetch();
				$stmt = self::instance()->prepare($sql);
				$stmt->bindParam(':index', $index);
        $stmt->execute();
				$row = false;
				while ($row = $stmt->fetch()) {
					return $row;
				}
			return $row;
		}
		
		public static function getlikedata($page,$ref,$index){
				$sql = "SELECT * FROM ".$page." WHERE ".$ref." LIKE :search";
			//$row = DB::run("SELECT * FROM pdowrapper WHERE id=?", [$id])->fetch();
				$stmt = self::instance()->prepare($sql);
        $stmt->execute(array(':search' => '%'.$index.'%'));
				$result = $stmt->fetchAll(PDO::FETCH_ASSOC);
				return $result;
		}

		public static function getspecificdata($column,$page,$ref,$index){
				$sql = "SELECT ".$column." FROM ".$page." WHERE ".$ref."=?";
			//$row = DB::run("SELECT * FROM pdowrapper WHERE id=?", [$id])->fetch();
				$stmt = self::instance()->prepare($sql);
        $stmt->execute([$index]);
				$result = $stmt->fetch(PDO::FETCH_ASSOC);
				return $result;
		}
}

?>