<?php
//SHORT FOR UpdateStructure
//used to map and track versioned updates to SQL databases
//written by Nathan Martin
class UpdStruct
{
    
    protected static $connection = null; //STORES PDO INSTANCE

    var $database_version = 0.01;
    var $export_path = 'application/structure';

    var $host = 'localhost';
    var $database = '';
    var $project = '';
    var $username = '';
    var $password = '';
    var $defaults = array('engine' => 'InnoDB','charset' => 'UTF8', 'collate' => 'UTF8_GENERAL_CI');

    var $tables = array();
    //var $tableStructure = array();

    function __construct(){
        return;
    }

    function connect($database,$username,$password,$host = 'localhost'){

        $this->database = $database;
        $this->project = $database;
        $this->username = $username;
        $this->password = $password;
        $this->host = $host;

        $pdo_reporting_type = PDO::ERRMODE_WARNING;
        //$pdo_reporting_type = PDO::ERRMODE_EXCEPTION;
        if (self::$connection === null)
        {
            $opt  = array(
                PDO::ATTR_ERRMODE            => $pdo_reporting_type,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => FALSE
            );
            $dsn = 'mysql:host='.$this->host.';dbname='.$this->database.';charset=utf8';
            self::$connection = new PDO($dsn, $this->username, $this->password, $opt);
        }
        return self::$connection;
    }

    function describeTable($tablename){

        if(self::$connection == null){ throw new Exception('MUST CALL CONNECT() BEFORE YOU CAN DESCRIBE TABLE. '); return false; }

        //Query MySQL with the PDO object.
        //The SQL statement is: DESCRIBE [INSERT TABLE NAME]
        $statement = self::$connection->query('DESCRIBE ' . $tablename);

        //Fetch our result.
        $result = $statement->fetchAll(PDO::FETCH_ASSOC);

        //The result should be an array of arrays,
        //with each array containing information about the columns
        //that the table has.
        //var_dump($result);

        //For the sake of this tutorial, I will loop through the result
        //and print out the column names and their types.
        $res = array();
        foreach($result as $column){
            //echo $column['Field'] . ' - ' . $column['Type'], '<br>';
            $res[$column['Field']] = array('Type' => $column['Type'],'Extra' => $column['Extra'],'Key' => $column['Key'],'Default' => $column['Default']);
        }

        $this->tables[$tablename] = $res;

    }

    function showTables(){
        if(self::$connection == null){ throw new Exception('MUST CALL CONNECT() BEFORE YOU CAN CALL SHOW TABLE. '); return false; }

        //Query MySQL with the PDO object.
        //The SQL statement is: DESCRIBE [INSERT TABLE NAME]
        $statement = self::$connection->query('SHOW TABLES');

        //Fetch our result.
        $result = $statement->fetchAll(PDO::FETCH_BOTH);

        //The result should be an array of arrays,
        //with each array containing information about the columns
        //that the table has.
        //var_dump($result);

        //For the sake of this tutorial, I will loop through the result
        //and print out the column names and their types.
        foreach($result as $table){
           // echo $table[0]."<br />";
            $tableName = $table[0];
            $this->tables[$tableName] = array();
            $this->describeTable($tableName);
        }
    }

    function export(){

        if(!file_exists($this->export_path)){
           mkdir($this->export_path,0644);
        }
        $exported = json_encode($this->tables);
        if(file_exists($this->export_path.'/'.$this->project.'_'.$this->database_version.'.JSON')){
            throw new Exception($this->export_path.'/'.$this->project.'_'.$this->database_version.'.JSON ALREADY EXISTS! ABORTING...<br />DELETE THIS FILE AND RETRY');
        }
        $file = fopen($this->export_path.'/'.$this->project.'_'.$this->database_version.'.JSON','w');
        fwrite($file,$exported);
        fclose($file);
        echo "Exported Version ".$this->database_version." to ".$this->export_path.'/'.$this->project.'_'.$this->database_version.'.JSON <br />';
		$file = fopen($this->export_path.'/'.$this->project.'_latest.txt','w');
        fwrite($file,$this->database_version);
        fclose($file);
		echo "Updated ".$this->export_path.'/'.$this->project.'_latest.txt <br />';
        
    }

    //TRUE = MATCHES
    //FALSE = DOESNT MATCH
    function compare($filePath = 'default'){

        if(self::$connection == null){ throw new Exception('MUST CALL CONNECT() BEFORE YOU CAN CALL COMPARE. '); return false; }

        if($filePath == 'default'){
            $filePath = $this->export_path.'/'.$this->project.'_'.$this->database_version.'.JSON';
        }

        if(!file_exists($filePath)){
            echo($filePath.' doesnt exist.<br />');
			return true;
        }

        $orig = file_get_contents($filePath);
        $SOURCE_STRUCT_ARR = json_decode($orig,true);

        //REFRESH WORKING TABLES DATA
        if(empty($this->tables)){ $this->showTables(); }

        $WORKING_STRUCT = $this->tables;
               
        $ret = $WORKING_STRUCT == $SOURCE_STRUCT_ARR;

          /*   
        print "COMPARISON CHECK = ".$ret;
        print "<br /><br /><br /><br /><br /><br /><br />";
        print_r($SOURCE_STRUCT_ARR);
        //print "<br /><br /><br /><br /><br /><br /><br />";
       // print_r($WORKING_STRUCT);
       // exit();
       */
        if($ret){

            return $ret;

        }else{

            $SOURCE_STRUCT = json_decode($orig);
            return $SOURCE_STRUCT;

        }
       
        
    }

    function update(){

        $comp = $this->compare();
        $runAtEnd = array();
        if($comp !== true){
            echo 'Checking Database...<br />';
            foreach($comp as $table => $structure){
                //CHECK TABLE EXISTS
                if(isset($this->tables[$table])){
                    //echo $table."<br />";
                }else{
                    ///////+++ADD TABLE CODE!!!

                    $this->log('Missing Table '.$table);

                    $tableQuery = "CREATE TABLE `".$table."` ( `TEMPORARY` INT NOT NULL ) ENGINE = ".$this->defaults['engine']." CHARSET=".$this->defaults['charset']." COLLATE ".$this->defaults['collate'].";";
                   //echo $tableQuery;
                    $this->push($tableQuery);
                   
                    $runAtEnd[] = "ALTER TABLE `".$table."` DROP `TEMPORARY`";
                }

                //CHECK STRUCTURE
                foreach($structure as $column => $data){
                    //CHECK COLUMN EXISTS
                    if(isset($this->tables[$table][$column])){
                        //echo $table."<br />";
                    }else{
                        //echo 'missing '.$column;
                        $this->log('Missing Column: '.$column.' in Table: '.$table );
                        ///////+++ADD COLUMN CODE!!!
                        
                        $query = "ALTER TABLE `".$table."` ADD `".$column."` ".$data->Type." NOT NULL";

                        if(isset($data->Default) AND !empty($data->Default)){
                            $query .= " DEFAULT '".$data->Default."'";
                        }
                        if(isset($data->Extra) AND !empty($data->Extra)){
                            $query .= " ".strtoupper($data->Extra)." ";
                        }
                        if(isset($data->Key) AND !empty($data->Key)){
                            $key = '';
                            if($data->Key == 'PRI'){
                                $key = 'PRIMARY KEY';
                            }
                            if($data->Key == 'UNI'){
                                $key = ", ADD UNIQUE `".$column."` (`".$column."`(150))";
                            }
                            ///FIXED EMPTY KEY BUG
                            if($key !== ''){
                                $query .= " ".$key;
                            }
                        }

                        $query .= ";";
                        
                        $this->push($query);

                    }                       
                }


            }

            foreach($runAtEnd as $q){
                $this->push($q);
            }

            echo "<br /><strong>Update Complete! Upgraded to Version ".$this->database_version."</strong>";

        }else{
            echo "<br /><strong>Nothing to update. Version ".$this->database_version."</strong>";
        }

    }


    function log($message){
        $logPath = $this->export_path.'/upgradeLog.txt';
        echo $message."<br />";
        file_put_contents($logPath,date('m/d/Y H:i:s').' '.$message."\r\n",FILE_APPEND);
        return;
    }

    function push($sql){
        $stmt = self::$connection->prepare($sql);
            try{
                $stmt->execute();
            }catch(PDOException $e){
                $this->log("INVALID SQL QUERY: ".$sql);
                return false;
            }

            $this->log('+++ PUSHED : '.$sql);
            return true;
    }

}
?>