<?php 
/*
USEAGE

include_once('classes/facebookLogin.class.php');

$myFBlogin = new facebookLogin({YOURAPPID});

//ADD TO HEAD
$myFBlogin->initSDK();

//OPTIONALLY CHANGE ANY SETTINGS BEFORE RENDERING BUTTON
$myFBlogin->FBLoginButtonSize = 'medium';
$myFBlogin->FBLoginButtonWidth = '850';
$myFBlogin->FBLoginButtonLabel = 'login_with';

//ADD TO WHEREVER YOU WANT TO SHOW BUTTON
$myFBlogin->FBLoginButton();

//OPTIONAL ADD HANDLERS IN JQUERY FOR ONLOGIN AND ONLOGOUT

<script>
$(document).ready(function(){
	$('body').on('FBLogin',function(){
		alert('LOGGED IN');
    });
    $('body').on('FBLogout',function(){
		alert('LOGGED OUT');
	});
})
</script>

//OPTIONAL ADD STYLING

#facebookLoginClass_Logout{
	padding:5px;
	background: #4267B2;
	color: white;
	border:none;
	border-radius:5px;
	cursor: pointer;
	font-size: 14px;
}


*/
class facebookLogin{

    var $appid = ''; //get one at https://developers.facebook.com/apps/
    var $apiVersion = 'v3.0'; //update as new apis are available
    var $FBLoginButton = '';
    var $FBLoginButtonSize = 'large'; //large, medium, small.
    var $FBLoginButtonWidth = '600'; //PIXELS 
    var $FBLoginButtonLabel = 'continue_with'; //login_with OR continue_with 
    var $JSpath = ''; //UPDATE IF RELATIVE PATH TO facebookLogin.js is changed.

    /*FIELDS TO AUTOPUPULATE
    USE ID=
    [TEXTBOX] id='firstname'
    [TEXTBOX] id='lastname'
    [TEXTBOX] id='email'
    [BUTTON] id='fbloginbutton'
    */

    function __construct($appid,$JSpath = 'classes/facebookLogin.js'){

        if($appid == ''){
            throw new Exception('EMPTY FACEBOOK APID facebookLogin.class.php');
        }

        //SET APPID
        $this->appid = $appid;

        //SET JSPATH - UPDATE IF RELATIVE PATH TO facebookLogin.js is changed.
        $this->JSpath = $JSpath;


          /*
<div id='fbloginbutton' scope='public_profile,email' onlogin='checkLoginState();' class='fb-login-button' data-width='800' data-max-rows='5' data-size='large' data-button-type='login_with' data-show-faces='true' data-auto-logout-link='true' data-use-continue-as='true'></div>



<fb:login-button id='fbloginbutton'
          scope='public_profile,email'
          onlogin='checkLoginState();'>
          </fb:login-button>
          */
          
    }

    //ECHO THE REQUIRED SCRIPTS
    function initSDK(){
        echo "<script type='text/javascript' >
        window.fbAsyncInit = function() {
            FB.init({
              appId      : '".$this->appid."',
              cookie     : true,
              xfbml      : true,
              version    : 'v3.0'
            });
              
            FB.AppEvents.logPageView();   
                
                FB.getLoginStatus(function (response) {
                statusChangeCallback(response);
                });
              
          };
          </script>";
        echo "<script src='".$this->JSpath."' ></script>";
        return;
    }

    //IF showStatus = false -> insert a <p id='status' ></p> somewhere in your body for this script to work properly!
    function FBLoginButton($showStatus = true,$addStatusClass = ''){

        //CREATE BUTTON TO LOGIN VIA FB
        $this->FBLoginButton = "
        <div id='fbloginbutton' scope='public_profile,email' onlogin='checkLoginState();' class='fb-login-button' data-width='".$this->FBLoginButtonWidth."' data-max-rows='1' data-size='".$this->FBLoginButtonSize."' data-button-type='".$this->FBLoginButtonLabel."' data-show-faces='false' data-auto-logout-link='false' data-use-continue-as='true'></div>
        ";


        echo $this->FBLoginButton."<br /><p id='status' class='".$addStatusClass."' ></p>";
        return;
    }

}

?>