<?php
function loadScript($src){
    $ret = "<script src='"+src+"?v="+ceil(Date.now())+"'  ></script>";
    echo ret;
}

function go($location){
    $redir = urldecode($location);
    echo "<script type='text/javascript'>document.location.href='$redir'</script>";
    return;
}

//FUNCTION FOR GETTING SPECTHOMES PAGE
function parseURI(){
    $args = array();
    $retval = array('page' => 'login','redirect' => '','args' => $args);
    $uri = $_SERVER['REQUEST_URI'];

    if($uri !== ''){
        $uri = explode('?',$uri);
        $uri = explode('&',$uri[0]);
        $uri = explode('/',trim($uri[0]));
       
        $length = count($uri);
        $length = $length - 1;
        if(isset($uri[$length - 1])){
            if($uri[$length - 1] == 'dash'){
                $length = $length - 1;
            }
        }
        if(isset($uri[$length])){
            if(is_numeric($uri[$length]) and isset($uri[$length - 1])){
                $length = $length - 1;
            }
            $retval['page'] = $uri[$length];
        }
    }

    if(isset($_GET['message'])){
        $args['message'] = $_GET['message'];
    }
    if(isset($_GET['title'])){
        $args['title'] = $_GET['title'];
    }
    if(isset($_GET) AND !empty($_GET)){
        foreach($_GET as $key => $value){
            $args[$key] = $value;
        }
    }

    $retval['args'] = $args;   
    //print_r($retval);
    return $retval;

}

/**
 *  @brief toMoney
 *  
 *  @param string $val VALUE TO CONVERT WITHOUT $ SYMBOL
 *  @param bool  $abs ABSOLUTE CALCULATION - SET TO TRUE = NO CALC OF NEGATIVE NUMBERS
 *  @param string  $symbol SYMBOL TO PREPEND TO THE MONEY CONVERTED STRING
 *  @param int $r NUMBER OF DECIMALS TO INCLUDE ( CENTS ) DEFAULT TO 2
 *  @return string
 *  
 *  @details Convert a value to money format
 */
function toMoney($val,$abs = true,$symbol='$',$r=2){
    if($abs == false){
        $n = floatval($val); 
    }else{
        $n = floatval(abs($val)); 
    }
    
    //ENSURE JAVASCRIPT MATH COMPAT
    $n = round($n,2,PHP_ROUND_HALF_UP);
    
        $c = is_float($n) ? 1 : number_format($n,$r);
        $d = '.';
        $t = '';
        $sign = ($n < 0) ? '-' : '';
        $i = $n=number_format(abs($n),$r); 
        $j = (($j = strlen($i)) > 3) ? $j % 3 : 0; 
    
       return  $symbol.$sign .($j ? substr($i,0, $j) + $t : '').preg_replace('/(\d{3})(?=\d)/',"$1" + $t,substr($i,$j)) ;
    
    }

//FUNCTION TO GET USERS IP
function getUserIP() {
	
	if(isset($_SERVER["HTTP_CLIENT_IP"])){
	
		$ip = $_SERVER["HTTP_CLIENT_IP"];
	
	}elseif(isset($_SERVER["HTTP_X_FORWARDED_FOR"])){
	
		$_p = $_SERVER["HTTP_X_FORWARDED_FOR"];
		$_ips = explode(',', $_p);
		$ip = end($_ips) ;
	
	}elseif(isset($_SERVER["REMOTE_ADDR"])){
		$ip = $_SERVER["REMOTE_ADDR"];
	}else{
		//LIKELY LOCALHOST
		$ip = "localhost";
	}
    return trim($ip);
}



/**
 *  @brief filterTime
 *  
 *  @param string  $time
 *  @param bool  $long DETERMINES WHETHER TO RETURN VALUE WITH HOUR,MIN,SEC OR NOT. DEFAULT TO TRUE
 *  @return date
 *  
 *  @details Convert a string time to a proper date() format.
 */
function filterTime($time, $long = true){
    if($time == ""){
        if($long = true){
    $datetime = "0000-00-00 00:00:00";
        }else{
    $datetime = "0000-00-00";
        }
    }else{
        if($long == true){	
            $datetime = date( 'Y-m-d H:i:s',strtotime($time));
        }else{
            $datetime = date( 'Y-m-d',strtotime($time));
        }
    }
    return $datetime;
    }
    
    /**
     *  @brief filtertoFriendlyTime
     *  
     *  @param string  $time 
     *  @param bool  $long DETERMINES WHETHER TO RETURN VALUE WITH HOUR,MIN,SEC OR NOT. DEFAULT TO TRUE
     *  @return string
     *  
     *  @details CONVERT A DATE() TO A HUMAN READABLE FORMAT
     */
    function filtertoFriendlyTime($time, $long = true){
    
    if($long == true){	
        
    $datetime = date("m/d/Y g:i a", strtotime($time) );
    
    }else{
    $datetime = date("m/d/Y", strtotime($time) );	
    }
    
    if($time == "0000-00-00 00:00:00" or $time == "0000-00-00"){
    return "";
    }else{
    return $datetime;
    }
    
    
    }


    function getCurrentUrl(){
        $actual_link = "http" . ((array_key_exists('HTTPS', $_SERVER) && $_SERVER['HTTPS'] == "on") ? "s://" : "://") . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];	
        return $actual_link;
    }

    /**
 *  @brief decimalToPercent
 *  
 *  @param int  $decimal THE DECIMAL TO CONVERT
 *  @param bool  $includepercent INCLUDE PERCENT?
 *  @return string CONVERTED PERCENT
 *  
 *  @details convert a decimal to a percent
 */
function decimalToPercent($decimal,$includepercent = true){
	
	if($includepercent == true){
	
	return ($decimal * 100)."%";
	
	}else{
		return ($decimal * 100);
	}
}

/**
 *  @brief percentToDecimal
 *  
 *  @param string $percent 
 *  @return float CONVERTED DECIMAL
 *  
 *  @details convert a percent to a decimal
 */
function percentToDecimal($percent){
	
	if(strpos($percent,"%") !== false){
	$percent = explode("%",$percent);
	$percent = $percent[0];
	}
	
	return (float)$percent / 100;
}

/**
 *  @brief readCSV
 *  
 *  @param  string $csvFile PATH TO CSV FILE TO READ
 *  @return array CSV ROWS
 *  
 *  @details USED to read a csv file and get the rows in an array
 */
function readCSV($csvFile){
	$file_handle = fopen($csvFile, 'r');
	while (!feof($file_handle) ) {
		$line_of_text[] = fgetcsv($file_handle, 1024);
	}
	fclose($file_handle);
	return $line_of_text;
}

/**
 *  @brief randomKey
 *  
 *  @return string RANDOM GENERATED KEY
 *  
 *  @details used to generate a random hash
 */
function randomKey() {
    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
    $pass = array(); //remember to declare $pass as an array
    $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    for ($i = 0; $i < 50; $i++) {
        $n = rand(0, $alphaLength);
        $pass[] = $alphabet[$n];
    }
    return implode($pass); //turn the array into a string
}

/**
 *  @brief openMaps
 *  
 *  @param string $address
 *  @return string HREF
 *  
 *  @details returns the href to be used on a link to open the devices' proper maps application
 */
function openMaps($address){
	
	$address = urlencode($address);
	
	$urltemplates = array("default" => "http://maps.google.com?q=".$address,
	"ios" => "maps:?saddr=Current Location&daddr=".$address,
	"android" => "geo:0,0?q=".$address,
	"windows_phone7" => "maps:".$address,
	"windows_phone8" => "bingmaps:?where=".$address);
	
	$useragent = strtolower($_SERVER['HTTP_USER_AGENT']);
	$returnstr = $urltemplates['android'];
	
	if(strpos($useragent,'android') !== false){ $returnstr = $urltemplates['android']; }
	elseif(strpos($useragent,'apple') !== false){ $returnstr = $urltemplates['ios']; }
	elseif(strpos($useragent,'windows phone 7') !== false){ $returnstr = $urltemplates['windows_phone7']; }
	elseif(strpos($useragent,'windows phone 8') !== false){ $returnstr = $urltemplates['windows_phone8']; }
	else{ $returnstr = $urltemplates['default']; }
	
	return $returnstr;
	
}


function object_to_array($obj) {
	$arr = array();
        $_arr = is_object($obj) ? get_object_vars($obj) : $obj;
        foreach ($_arr as $key => $val) {
                $val = (is_array($val) || is_object($val)) ? object_to_array($val) : $val;
                $arr[$key] = $val;
        }
        return $arr;
}

function is_ajax_request(){
	if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest'){
		return true;
	}else{
		return false;
	}
}

function trim_all( $str , $what = NULL , $with = ' ' )
{
    if( $what === NULL )
    {
        //  Character      Decimal      Use
        //  "\0"            0           Null Character
        //  "\t"            9           Tab
        //  "\n"           10           New line
        //  "\x0B"         11           Vertical Tab
        //  "\r"           13           New Line in Mac
        //  " "            32           Space
       
        $what   = "\\x00-\\x20";    //all white-spaces and control chars
    }
   
    return trim( preg_replace( "/[".$what."]+/" , $with , $str ) , $what );
}
?>