<?php 

require_once('phpHelpers.php');

/*
    USED TO TRACK AND LOG ANY REQUESTS THAT EXCEED X SPEEDLIMIT SECONDS

    $speedDemon = new speedDemon(5);

    //TEST LOG
    $speedDemon->speedTest();

    //OUTPUT LOAD TIME
    $speedDemon->showOff();
*/

class speedDemon {

private $start;
var $speedlimit = 5.00;
var $logPath = 'logs/speedDemon.txt';

public function __construct($speedlimit = 5.00,$logPath = 'logs/speedDemon.txt') {
    if(isset($_SERVER["REQUEST_TIME_FLOAT"])){
        $this->start = $_SERVER["REQUEST_TIME_FLOAT"];
    }else{
        $this->start = microtime(true);
    }


    $this->speedlimit = $speedlimit;
    $this->logPath = $logPath;
    return;

}

public function segs() {
    return microtime(true) - $this->start;
}

public function time() {
    $segs = $this->segs();
    $days = floor($segs / 86400);
    $segs -= $days * 86400;
    $hours = floor($segs / 3600);
    $segs -= $hours * 3600;
    $mins = floor($segs / 60);
    $segs -= $mins * 60;
    $microsegs = ($segs - floor($segs)) * 1000;
    $segs = floor($segs);

    return $segs;
}

function showOff(){
    echo "<p title='We care about your user experience, and your time. So, we track all load times for quality assurance purposes.' style='font-style:italic;' >Loaded in ".( $this->time() > 0 ? $this->time() : "less than a ")." second".( $this->time() > 1 ? 's' : '')."</p>" ;
    return;
}

function __destruct(){
    
    $addedInfo = '';

    if(isset($_POST) and !empty($_POST)){
        $addedInfo .= "POSTED DATA ".print_r($_POST,true);
    }

    if($this->time() >= $this->speedlimit){
        $this->log('Warning - load time exceeded '.$this->speedlimit." seconds. LOAD TIME: ".$this->time()." Seconds. \r\n\r\n URL: ".getCurrentUrl()." \r\n\r\n ADDITIONAL INFO: ".$addedInfo);
    }
}

function speedTest($iterations = 30000){
        $i = 1;
    while($i <= 5000 * $iterations){
        $t = (5 + 9) * 6004450;
        $i++;
    }

    return $i;
}


function log($message){
    $logPath = $this->logPath;

    file_put_contents($logPath,date('m/d/Y H:i:s').' '.$message."\r\n \r\n ############################# END ######################### \r\n \r\n",FILE_APPEND);
    return;
}

}


?>