<?php 
//tālāria are winged sandals, a symbol of the Greek messenger god Hermes
//REQUIRES PHPMAILER
//DESCRIPTION: USED TO EASILY INITIATE THE PHPMAILER AND SEND MAIL IN A PREDEFINED, TEMPLATES WAY WITH TRACKABLE LINKS AND OPEN TRACKING
//WRITTEN BY NATHAN MARTIN

/*

/////EXAMPLE USAGE///////

    require('classes/talariaMail.class.php');

    //create body html - DONT INCLUDE <HTML> AND <BODY>
    $body = '<div >Hello my name is body</div><div>This is second line</div>';

    //CREATE SUBJECT
    $subject = 'Subject line';

    //CREATE EMAILS ARRAY
    $emails = array('sagedread@gmail.com' => 'john doe','sagedread2@gmail.com' => 'john doe2');
    
    //INSTANTIATE TALARIA
    $mailer = new talariaMail($emails,$subject,$body);

    //SET LOG PATH
    $mailer->logPath = 'var/log/mail_log.txt';

    //SET LOG MODE ACCEPTS all,errors,none
    $mailer->logMode = 'all';

    //SET FROM EMAIL AND FROM NAME
    $mailer->fromEmail = 'test@from.com';
    $mailer->fromName = 'from name';

    //SET REPLY TO OPTIONALLY
    $mailer->replyTo = array('replys@email.com' => 'replyname');

    //ACTUALLY SEND THE EMAIL RETURNS BOOL TRUE OR FALSE
    if($mailer->send()){
        //TRUE
    }else{
        //FALSE
    }

*/

require_once('libs/PHPMailer-master/src/PHPMailer.php');
require_once('libs/PHPMailer-master/src/SMTP.php');
require_once('libs/PHPMailer-master/src/Exception.php');

class talariaMail{

    //SETTINGS
    var $fromEmail = '';
    var $fromName = '';
    var $replyTo = array(); //array('replys@email.com' => 'replyname');
    var $attachments = array();
    var $logPath = 'logs/talariaMail_logs.txt';
    var $logMode = 'errors'; //ACCEPTS all,errors,none
    var $template = "<html><body> {BODY} </body></html>"; //{BODY} GETS REPLACED WITH THE HTML OF THE EMAIL BEING SENT.

    //END SETTINGS
    
    var $mailerExceptions = true;
    var $sendMailTransport = false; //ONLY WITH XAMPP REALLY
    var $toEmails = array(); //array('replys@email.com' => 'replyname');
    var $subject = '';
    var $body = '';
    var $txtbody = '';
    var $phpmailer_instance = null;
    
    private $tracker = 'default';
    private $ident = '';

    /**
     * talariaMail
     * tālāria are winged sandals, a symbol of the Greek messenger god Hermes
     * Simple class to create and send templates phpMailer emails
     * REQUIRES PHPMAILER
     * 
     * 
     * 
     * */
    function __construct($to,$subject,$body){

        $this->phpmailer_instance = new PHPMailer\PHPMailer\PHPMailer(true);                          // Passing `true` enables exceptions

        if($this->sendMailTransport){
            $this->phpmailer_instance->IsSendmail();
        }

        if(is_array($to)){
            $this->toEmails = $to;
        }else{
            $this->toEmails[$to] = '';
        }

        if(empty($subject)){
            throw new Exception('INVALID OR BLANK SUBJECT'.$subject);
        }
        $this->subject = $subject;

        if(empty($body)){
            throw new Exception('INVALID OR BLANK BODY'.$body);
        }
        $this->body = $body;

        $this->txtbody = preg_replace( "/\n\s+/", "\n", rtrim(html_entity_decode(strip_tags($this->body))) );
        
    }

    function send(){

        //PROCESS TEMPLATE
        if(strpos($this->template,'{BODY}') !== false){
            $this->body = str_replace('{BODY}',$this->body,$this->template);
            }

        try {

            $this->phpmailer_instance->setFrom($this->fromEmail, $this->fromName);


            
            //ADD REPLY TO EMAILS
            ///$replytos = array('email@email.com' => 'JOHN DOE');
            ///////OR
            ///$replytos = array('email@email.com','email2@email.com');
            foreach($this->replyTo as $email => $value){
                if(isset($value)){
                    $name = $value;
                }else{
                    $name = '';
                }

                $this->phpmailer_instance->addReplyTo($email, $name);
            }

            //ADD TO EMAILS
            ///$emails = array('email@email.com' =>  'JOHN DOE');
            ///////OR
            ///$emails = array('email@email.com','email2@email.com');
            foreach($this->toEmails as $email => $value){
                if(isset($value)){
                    $name = $value;
                }else{
                    $name = '';
                }

                $this->phpmailer_instance->addAddress($email, $name);     // Add a recipient
            }

            //ADD ATTACHMENTS
            ///$attachments = array('tmp/file.jpg' => array('name' => 'filename.jpg'));
            ///////OR
            ///$attachments = array('tmp/file.jpg','tmp/file2.jpg');
            foreach($this->attachments as $path => $value){
                if(isset($value['name'])){
                    $this->phpmailer_instance->addAttachment($path, $value['name']); 
                }else{
                    $this->phpmailer_instance->addAttachment($path); 
                }
            }

            //PREPARE BODY AND TXT BODY AND SUBJECT
            $this->phpmailer_instance->isHTML(true);  // Set email format to HTML
            $this->phpmailer_instance->Subject = $this->subject;
            $this->phpmailer_instance->Body    = $this->body;
            $this->phpmailer_instance->AltBody = $this->txtbody;

            //SEND
            $this->phpmailer_instance->send();
            
            if($this->logMode == 'all'){
                $this->log("SENT EMAIL TO \r\n ".print_r($this->toEmails,true)." BODY \r\n ".$this->body );
            }

            return true;
         } catch (Exception $e) {

            if($this->logMode !== 'none'){
                $this->log($this->phpmailer_instance->ErrorInfo);
            }
                echo 'Message could not be sent. Mailer Error: ', $this->phpmailer_instance->ErrorInfo;
                return false;
        }

    }

    function log($message){
        $logPath = $this->logPath;
       // echo $message."<br />";
        file_put_contents($logPath,date('m/d/Y H:i:s').' '.$message."\r\n",FILE_APPEND);
        return;
    }


}

/*

$mail = new PHPMailer\PHPMailer\PHPMailer(true);                          // Passing `true` enables exceptions
try {
    //Server settings
    $mail->SMTPDebug = 2;                                 // Enable verbose debug output
    $mail->isSMTP();                                      // Set mailer to use SMTP
    $mail->Host = 'smtp1.example.com;smtp2.example.com';  // Specify main and backup SMTP servers
    $mail->SMTPAuth = true;                               // Enable SMTP authentication
    $mail->Username = 'user@example.com';                 // SMTP username
    $mail->Password = 'secret';                           // SMTP password
    $mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
    $mail->Port = 587;                                    // TCP port to connect to

    //Recipients
    $mail->setFrom('from@example.com', 'Mailer');
    $mail->addAddress('joe@example.net', 'Joe User');     // Add a recipient
    $mail->addAddress('ellen@example.com');               // Name is optional
    $mail->addReplyTo('info@example.com', 'Information');
    $mail->addCC('cc@example.com');
    $mail->addBCC('bcc@example.com');

    //Attachments
    $mail->addAttachment('/var/tmp/file.tar.gz');         // Add attachments
    $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name

    //Content
    $mail->isHTML(true);                                  // Set email format to HTML
    $mail->Subject = 'Here is the subject';
    $mail->Body    = 'This is the HTML message body <b>in bold!</b>';
    $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

    $mail->send();
    echo 'Message has been sent';
} catch (Exception $e) {
    echo 'Message could not be sent. Mailer Error: ', $mail->ErrorInfo;
}

*/

?>