<?php 

class sagecore_files{
var $basedirectory = 'private/uploads';
var $folder = 'misc';
var $domain = '';
var $upload_mb = '';
var $acceptable_files = null;

//THESE MUST BE SET IN NEW INSTANCE
	var $associated_table = null;
	var $associated_id = null;
	var $action = null; //THE URL YOU WANT USERS TO FIND THESE FILES IN. THIS IS WHERE USERS WILL BE NOTIFIED AND TAKEN TO THIS URL.
	
	public function __construct(){
			
			//SET UPLOAD_MB
			$max_upload = (int)(ini_get('upload_max_filesize'));
			$max_post = (int)(ini_get('post_max_size'));
			$memory_limit = (int)(ini_get('memory_limit'));
			$this->upload_mb = min($max_upload, $max_post, $memory_limit);
			
			$acceptable_files = 'pdf,png,jpg,jpeg,gif';
			
			$this->acceptable_files = explode(',',$acceptable_files);
			
			return true;
		
	}
	
	public function init(){
	//CALL THIS AFTER YOUVE OVERRIDDEN $this->basedirectory if necessary
		
		require 'config/coreconfig.php';

		//CHECK TO ENSURE TRAILING / IS PRESENT IF SO REMOVE IT
		if(strpos($this->basedirectory	,'/') !== false){
			//print "UPLOADDIR NEEDS TO BE IN THIS FORMAT 'FOLDER/' - YOU FORGOT THE TRAILING SLASH / - ADDING IT FOR YOU.";
			$this->basedirectory = str_replace('/','',$this->basedirectory);
		}
		

		//CHECK TO ENSURE TRAILING / IS PRESENT
		if(strpos($this->folder	,'/') !== false){
			//print "UPLOADDIR NEEDS TO BE IN THIS FORMAT 'FOLDER/' - YOU FORGOT THE TRAILING SLASH / - ADDING IT FOR YOU.";
						$this->folder = str_replace('/','',$this->folder);
		}	
		
		
		$_uploaddir	= $this->basedirectory;		
		
		$_uploadfolder	= $this->folder;
		$this->domain = $config['rootdomain'];
		
		$_uploaddir	= $config['rootfiles'] . "/system/". $_uploaddir;
		
		/*
		if($debug == 1){
			print $_uploaddir;
		}
		*/
		
		
		//CHECK IF FILE STRUCTURE IS PRESENT FIRST.
		if (!file_exists($_uploaddir)) {
				mkdir($_uploaddir, 0755, true);
		}
		$fulldir = $_uploaddir.'/'.$_uploadfolder;
		if (!file_exists($fulldir)) {
				mkdir($fulldir, 0755, true);
		}
		
		
		//$this->basedirectory = $_uploaddir;
		//$this->folder = $_uploadfolder;
	}
	
	
	//call upload() in the script reciving the $_FILES
	public function upload(){
		require 'config/coreconfig.php';
		if(!isset($_FILES) or !isset($_POST)){
			return false; exit();
		}
		
		
		$file = array_shift($_FILES);	
		exit(print_r($file));
		$filename = strtolower($file['name']);
		$name = preg_replace('/\s+/', '_', $filename); //REPLACE SPACES
		$name = str_replace(array("'",'"',"?"),"",$name); //FILTER ANY WEIRD CHARACTERS.

		$thedate = date('m_d_y',time()); //PREVENTS OVERWRITING OLD FILES WITH SAME FILE NAMES

		$uploadfile = basename($thedate."_".$name);
		$displayfile = basename($name);
		
		//BACKWARDS COMPATIBILITY
		$relpath = "/".$this->basedirectory."/".$this->folder."/".$uploadfile;
		$path = SAGECORE_ROOTFILES . $relpath;
			
		
		$extension = explode(".", $name);
		$extension = end($extension);
		$extension = str_replace('.','',$extension);
		
		$displayName = str_replace($extension,'',$displayfile);
		$displayname = substr($displayName,0,15);
		$displayname = $displayname.".".$extension;
		
		define('MB', 1048576);
		
		if(is_array($this->acceptable_files) AND !in_array($extension,$this->acceptable_files)){ //invalid extension check
				$data = array(
						'result' => false,
						'error' => 'invalidExtension',
						'message' => 'Unacceptable file type [.'.$extension.']'
					);
		}elseif( intval($this->upload_mb) !== 0 && $file['size'] > ($this->upload_mb * MB)){ //upload max check
				$data = array(
						'result' => false,
						'error' => 'toolargefile',
						'message' => 'File is too large.'
					);
		}elseif(file_exists($path)) { //file exists
			$data = array(
						'result' => false,
						'error' => 'existing file!',
						'message' => 'File exists.'
					);
		}elseif (is_uploaded_file($file['tmp_name'])) { 
		if (move_uploaded_file($file['tmp_name'], $path)) {
		
		
			//double verify file exists
			if (file_exists($path)) {
						$data = array(
							'result' => true,
							'path' => $config['root'].$relpath,
							'message' => 'File Uploaded',
							'displayName' => $displayname
						);
			}
					
		
		}
		}
	
		
		//CHECK FOR FAILURE
		if($data['success'] == false){
				http_response_code(415);
		}else{
				http_response_code(200);
		}
		
			if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
				echo json_encode($data); //ECHO FOR AJAX REQUESTS
				//echo $data['message']; //ECHO FOR AJAX REQUESTS
			}
		
		return json_encode($data);
		
	}
}

?>