<?php

require_once('phpHelpers.php');

class logger
{
        var $logFile = '';
        var $handle = '';
        var $logPath = '';
        var $mode = '';
		var $label = '';
		var $userIp = '';

		/**
		 * Initiate the instance of logger class
		 *
		 * @param string $logFile
		 * @param string $label
		 * @param string $path
		 * @param string $mode
		 *
		 * @return void
		 */
        function __construct($logFile, $label, $path='/var/log/', $mode='a')
        {
                /**When constructing this class:*/
                //$logFile is the 'mylog.log' file, 
                //$label is the first line label that appears after the timestamp, 
                //$handle allows you to pass a parent logger object / parent class' file handle for its logger object. So, all messages appear in once file.
                //$path tells us where to put it, and 
                //$mode is the write mode of the file.

				$this->label = $label;
				$this->logFile = $logFile;
				$this->logPath = $path;
				$this->mode = $mode;
				$this->userIp = getUserIP();
				/*if($handle !== null){
					$this->logFile = $logFile;
					$this->logPath = $path;
					$this->mode = $mode;
					$this->handle = $handle;
                }
				else {*/
 					
 				// }
                //$this->log(sprintf("%s starting up...",$this->label));
                    //echo getcwd().$this->logPath.$this->logFile;
					try{
						$this->handle = fopen(getcwd()."/".$this->logPath.$this->logFile,$this->mode);
					}catch(Exception $e){
						$this->handle = false;
						return false;
					}
    				$this->log("====== START ( ".date("d-m-Y :: h:i:s")." ) IP ".$this->userIp." ===== ",'') ;
    				$this->log("----- REQUEST -----\r\n".json_encode($_REQUEST)."\r\n",'') ;
    				if( isset($_FILES) && !empty($_FILES) ){ // write log for image file
    					$this->log("\r\n----- FILES -----\r\n".json_encode($_FILES)."\r\n",'') ;
    				}
                
				
        }

		/**
		 * This method write the message to file
		 *
		 * @param string $message
		 *
		 * @return void
		 */
        function log($message,$indent = '  +++++  ')
        {

    			$format = $indent.$message."\r\n";
				if(!$this->handle){
					return false;
				}
    			fwrite($this->handle, $format);
            
        }

		/**
		 * Destroy the instance of logger class
		 *
		 * @return void
		 */
        function __destruct()
        {

    			$this->log("=== END ===\r\n",'') ;
    			//fwrite($this->handle,"\r\n");
				if(!$this->handle){
					return false;
				}
    			fclose($this->handle);
        
        }
}